cls
function Get-FileFormatDate {
    param( [DateTime]$Date = [DateTime]::now )
    return $Date.ToUniversalTime().toString( "yyyy-MM-dd_hh-mm-ss" )
}
if((Get-PSSnapin | Where {$_.Name -eq "Microsoft.SharePoint.PowerShell"}) -eq $null) {
		Add-PSSnapin Microsoft.SharePoint.PowerShell;
    }
$continue = Read-Host "This script will change SharePoint configuration files, registry and will restart your IIS! Would you like to continue (Y/N)"
if($continue -eq "Y")
{
	Write-Host -ForegroundColor Yellow "Configuring PDF Icon..."
	$SharePointRoot = "C:\Program Files\Common Files\Microsoft Shared\Web Server Extensions\14";
	$DocIconFolderPath = "$SharePointRoot\TEMPLATE\XML";
	$DocIconFilePath = "$DocIconFolderPath\docicon.xml";
	Write-Host "Creating backup of DocIcon.xml file..."
	$dateNow = Get-FileFormatDate
	$backupFile = "$DocIconFolderPath\Backup_DocIcon_" + $dateNow + ".xml"
	Copy-Item $DocIconFilePath $backupFile
	$pdfIcon = "pdficon_small.gif";
	while((Get-Item $pdfIcon) -eq $null)
	{
		Read-Host "$pdfIcon is missing. Download it from http://www.adobe.com/misc/linking.html and place it to this folder. Press any key to continue...";
	}
	Copy-Item $pdfIcon "$SharePointRoot\Template\Images";
	$pdfNode = select-xml -path $DocIconFilePath -xpath "/DocIcons/ByExtension/Mapping[@Key='pdf']" | select-object -expandProperty Node
	if($pdfNode -eq $null)
	{
		 $xml= (Get-Content $DocIconFilePath)
		 $a = $xml.selectSingleNode("/DocIcons/ByExtension")
		 $addnode = $xml.createElement("Mapping")
		 $a.AppendChild($addNode)
		 $keyAttribute = $xml.CreateAttribute("Key")
	     $keyAttribute.set_Value("pdf")
	     $addNode.SetAttributeNode($keyAttribute)
		 $valueAttribute = $xml.CreateAttribute("Value")
	     $valueAttribute.set_Value("pdficon_small.gif")
	     $addNode.SetAttributeNode($valueAttribute)
	     $xml.Save($DocIconFilePath)
	}
	Write-Host -ForegroundColor Yellow "Configuring search crawl extension..."
	$searchServiceApp = Read-Host "Type the name of your search service application (e.g. Search Service Application)"
	$searchApplicationName = Get-SPEnterpriseSearchServiceApplication $searchServiceApp
	if($searchApplicationName -ne $null)
	{
		if(($searchApplicationName | Get-SPEnterpriseSearchCrawlExtension "pdf") -eq $null)
		{
			$searchApplicationName | New-SPEnterpriseSearchCrawlExtension "pdf"
		}
	}
	Write-Host -ForegroundColor Yellow "Updating registry..."
	if((Get-Item -Path Registry::"HKLM\SOFTWARE\Microsoft\Office Server\14.0\Search\Setup\Filters\.pdf") -eq $null)
	{
		$item = New-Item -Path Registry::"HKLM\SOFTWARE\Microsoft\Office Server\14.0\Search\Setup\Filters\.pdf"
		$item | New-ItemProperty -Name Extension -PropertyType String -Value "pdf"
		$item | New-ItemProperty -Name FileTypeBucket -PropertyType DWord -Value 1
		$item | New-ItemProperty -Name MimeTypes -PropertyType String -Value "application/pdf"
	}
	if((Get-Item -Path Registry::"HKLM\SOFTWARE\Microsoft\Office Server\14.0\Search\Setup\ContentIndexCommon\Filters\Extension\.pdf") -eq $null)
	{
		$registryItem = New-Item -Path Registry::"HKLM\SOFTWARE\Microsoft\Office Server\14.0\Search\Setup\ContentIndexCommon\Filters\Extension\.pdf";
		$registryItem | New-ItemProperty -Name "(default)" -PropertyType String -Value "{E8978DA6-047F-4E3D-9C78-CDBE46041603}"
	}
	[System.Environment]::SetEnvironmentVariable("PATH", $Env:Path + ";C:\Program Files\Adobe\Adobe PDF iFilter 9 for 64-bit platforms\bin", "Machine")
	
	Write-Host -ForegroundColor Yellow "Restarting SharePoint Foundation Search Service..."
	Restart-Service SPSearch4
	Write-Host -ForegroundColor Yellow "Restarting SharePoint Search Service..."
	Restart-Service OSearch14
	Write-Host -ForegroundColor Yellow "Restarting IIS..."
	iisreset
	Write-Host -ForegroundColor Green "Installation completed..."
}